SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


---------------------------------
-- Sp_UpdateRespondentResponse --
---------------------------------

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_UpdateRespondentResponse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
GO


CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
 @ProjectId     INT,
 @UserId        INT,
 @CollectMode   INT,
 @RpsRespondent VARCHAR(10),
 @RpsQuestion   VARCHAR(10),
 @RpsMatrix     BIGINT,
 @RpsMention    INT,
 @RpsContent    NVARCHAR(100),
 @rpsOpened     NTEXT,
 @rpsType       INT,
 @CallId        INT,
 @Source        nvarchar(max),
 @Modified      datetime = null
AS

 IF @Modified is null SET @Modified = GETUTCDATE();
 
  UPDATE Response
  SET    ProjectId = @ProjectId,
         CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
         modifiedby = @UserId,
         modified = @Modified,
         RpsContent = @RpsContent,
         RpsOpened = @RpsOpened,
         CallId = @CallId,
         [Source] = @Source
  WHERE  RpsRespondent = @RpsRespondent
         AND RpsQuestion = @RpsQuestion
         AND RpsMatrix = @RpsMatrix
         AND RpsMention = @RpsMention
         AND RpsType = @RpsType
  IF @@ROWCOUNT = 0
  BEGIN
    INSERT INTO Response
    (RpsRespondent,
     ProjectId,
     CollectMode,
     modifiedby,
     modified,
     RpsQuestion,
     RpsMatrix,
     RpsMention,
     RpsContent,
     RpsOpened,
     RpsType,
     CallId,
     [Source])
 VALUES    (@RpsRespondent,
     @ProjectId,
     @CollectMode,
     @UserId,
     @Modified,
     @RpsQuestion,
     @RpsMatrix,
     @RpsMention,
     @RpsContent,
     @rpsOpened,
     @rpsType,
     @CallId,
     @Source)
  END

GO

